/**
 * Created by HAS on 16/01/2015.
 */

/** To call functions when an HTML overlay is visible in the HTML Reader...

   1. Once you have exported your animation, open index.html, and add the following line within the <head> tag:
          <script type="text/javascript" charset="utf-8" src="htmlOverlayVisible.js"></script>
      Ensure that it is ABOVE this line, which should be already there:
          <script type="text/javascript" charset="utf-8" src="edge_includes/edge.5.0.0.min.js"></script>

   2. Then, place THIS FILE into the HTML overlay's root folder.

   3. Finally, Use htmlOverlayVisible.registerFunction(functionName) to add a function to the list of functions
      that are called when an HTML overlay is visible.

* * * * * * * * * * * * * * * * * * * *

    SPECIFIC EXAMPLE: To make an Edge animation play only when visible, open index_edgeActions.js and add the
    code fragment below DIRECTLY UNDERNEATH the line: (function(symbolName){

* * * * * * * * * * * * * * * * * * * *

    	Symbol.bindSymbolAction(compId, symbolName, "creationComplete", function(sym, e) {

		    function playEdgeAnimation(){
			    sym.play(0);
		    };

		    htmlOverlayVisible.registerFunction(playEdgeAnimation);
	    });

* * * * * * * * * * * * * * * * * * * */


var htmlOverlayVisible = (function () {

    //stored state so that we can inform registering functions of the current state
    var isVisible = false;
    var ret = {};
    var overlayVisibleFunctions = [];

    ret.registerFunction = function (myFunction) {
        overlayVisibleFunctions.push(myFunction);
        //if the overlay is currently visible, inform it
        if (isVisible) {
            myFunction();
        }
    };

    function whenOverlayVisible(m) {
        var message = m.data.split(':')[0];
        if (message == 'overlayVisible') {
            isVisible = true;
            for (var i = 0, l = overlayVisibleFunctions.length; i < l; i++) {
                overlayVisibleFunctions[i]();
            }
        }
        else if (message == 'overlayNotVisible') {
            //update the state but don't call any functions as they only want to know when they become visible
            isVisible = false;
        }
    }

    window.addEventListener('message', whenOverlayVisible, false);
    //inform the reader that we are ready to receive messages
    window.parent.postMessage('overlayAttached', '*');
    return ret;
}());
